/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.WordData;
import org.languagetool.JLanguageTool;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.WordTagger;

public class MorfologikTagger
implements WordTagger {
    private final URL dictUrl;
    private Dictionary dictionary;

    public MorfologikTagger(String dictPath) {
        this.dictUrl = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(Objects.requireNonNull(dictPath));
    }

    MorfologikTagger(URL dictUrl) {
        this.dictUrl = Objects.requireNonNull(dictUrl);
    }

    public MorfologikTagger(Dictionary dictionary) {
        this.dictUrl = null;
        this.dictionary = dictionary;
    }

    private synchronized Dictionary getDictionary() throws IOException {
        if (this.dictionary == null) {
            this.dictionary = Dictionary.read(this.dictUrl);
        }
        return this.dictionary;
    }

    @Override
    public List<TaggedWord> tag(String word) {
        ArrayList<TaggedWord> result = new ArrayList<TaggedWord>();
        try {
            DictionaryLookup dictLookup = new DictionaryLookup(this.getDictionary());
            List<WordData> lookup = dictLookup.lookup(word);
            for (WordData wordData : lookup) {
                String tag;
                String string = tag = wordData.getTag() == null ? null : wordData.getTag().toString();
                if (this.dictionary.metadata.isFrequencyIncluded() && tag != null && tag.length() > 1) {
                    tag = tag.substring(0, tag.length() - 1);
                }
                String stem = wordData.getStem() == null ? null : wordData.getStem().toString();
                TaggedWord taggedWord = new TaggedWord(stem, tag);
                result.add(taggedWord);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not tag word '" + word + "'", e);
        }
        return result;
    }
}

